<?php
// public/tutor/my_bookings.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('tutor');

$tid = $_SESSION['user_id'];
$msg = '';
$error = '';

// --- HANDLE ACTIONS (Accepting Suggestions) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'accept_suggestion') {
        $id = (int)$_POST['id'];
        
        $check = $conn->query("SELECT id FROM bookings WHERE id=$id AND tutor_id=$tid");
        if ($check->num_rows > 0) {
            $stmt = $conn->prepare("UPDATE bookings SET start_time = suggested_start, end_time = suggested_end, status = 'approved', suggested_start = NULL, suggested_end = NULL WHERE id = ?");
            $stmt->bind_param("i", $id);
            
            if ($stmt->execute()) {
                $msg = "You accepted the new time. Your booking is now Confirmed!";
                
                // --- NEW CODE: NOTIFY ADMINS ---
                $tutor_name = user()['name'];
                $admins = $conn->query("SELECT id FROM users WHERE role='admin'");
                while($admin = $admins->fetch_assoc()) {
                    notify($admin['id'], "Suggestion Accepted by $tutor_name. Booking is confirmed.", "admin/bookings.php");
                }
                // -------------------------------
                
            } else {
                $error = "Database error: " . $conn->error;
            }
        } else {
            $error = "Unauthorized action.";
        }
    }
}

// Fetch bookings
$bookings = $conn->query("SELECT b.*, l.name as lab_name, c.name as course_name 
                          FROM bookings b 
                          JOIN labs l ON b.lab_id = l.id 
                          LEFT JOIN courses c ON b.course_id = c.id 
                          WHERE b.tutor_id = $tid 
                          ORDER BY b.created_at DESC");

tailwind_head("My Bookings");
?>

<?php include '_nav.php'; ?>

<div class="mx-auto max-w-7xl px-4 pb-10">
    <h2 class="text-2xl font-bold mb-6">My Bookings History</h2>
    
    <?php if($msg): ?><div class="p-4 mb-4 text-green-700 bg-green-100 rounded shadow-sm"><?= e($msg) ?></div><?php endif; ?>
    <?php if($error): ?><div class="p-4 mb-4 text-red-700 bg-red-100 rounded shadow-sm"><?= e($error) ?></div><?php endif; ?>

    <div class="overflow-x-auto bg-white shadow ring-1 ring-black ring-opacity-5 sm:rounded-lg">
        <table class="min-w-full divide-y divide-slate-300">
            <thead class="bg-slate-50">
                <tr>
                    <th class="py-3.5 pl-4 text-left text-sm font-semibold text-slate-900">Date & Time</th>
                    <th class="px-3 py-3.5 text-left text-sm font-semibold text-slate-900">Details</th>
                    <th class="px-3 py-3.5 text-left text-sm font-semibold text-slate-900">Status</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-slate-200 bg-white">
                <?php while($row = $bookings->fetch_assoc()): 
                    $color = match($row['status']) {
                        'approved' => 'text-green-700 bg-green-50 ring-green-600/20',
                        'rejected' => 'text-red-700 bg-red-50 ring-red-600/10',
                        'pending'  => 'text-yellow-800 bg-yellow-50 ring-yellow-600/20',
                        'change_requested' => 'text-indigo-700 bg-indigo-50 ring-indigo-600/20',
                        default    => 'text-slate-700 bg-slate-50 ring-slate-500/10'
                    };
                ?>
                <tr>
                    <td class="whitespace-nowrap py-4 pl-4 text-sm text-slate-900 align-top">
                        <div class="<?= $row['status'] == 'change_requested' ? 'line-through text-slate-400' : 'font-medium' ?>">
                            <?= date('M d, Y', strtotime($row['start_time'])) ?>
                        </div>
                        <div class="<?= $row['status'] == 'change_requested' ? 'line-through text-slate-300' : 'text-slate-500' ?>">
                            <?= date('H:i', strtotime($row['start_time'])) ?> - <?= date('H:i', strtotime($row['end_time'])) ?>
                        </div>
                    </td>
                    <td class="px-3 py-4 text-sm text-slate-500 align-top">
                        <div class="font-bold text-slate-900"><?= e($row['course_name'] ?? 'Unknown Course') ?></div>
                        <div><span class="font-medium">Lab:</span> <?= e($row['lab_name']) ?></div>
                        <div class="text-xs mt-1"><span class="font-medium">Purpose:</span> <?= e($row['purpose']) ?></div>
                        <?php if(!empty($row['notes'])): ?>
                            <div class="mt-2 text-xs text-slate-500 italic border-l-2 border-slate-300 pl-2">
                                "<?= e($row['notes']) ?>"
                            </div>
                        <?php endif; ?>
                    </td>
                    <td class="px-3 py-4 text-sm align-top">
                        <span class="inline-flex items-center rounded-md px-2 py-1 text-xs font-medium ring-1 ring-inset <?= $color ?>">
                            <?= ucfirst(str_replace('_', ' ', $row['status'])) ?>
                        </span>
                        <?php if($row['status'] == 'rejected' && !empty($row['rejection_reason'])): ?>
                            <div class="mt-2 text-xs text-red-600 bg-red-50 p-2 rounded border border-red-100 max-w-[220px]">
                                <strong>Admin Note:</strong> <?= e($row['rejection_reason']) ?>
                            </div>
                        <?php endif; ?>
                        <?php if($row['status'] == 'change_requested' && !empty($row['suggested_start'])): ?>
                            <div class="mt-3 bg-indigo-50 p-3 rounded border border-indigo-100 max-w-[250px]">
                                <p class="text-xs font-bold text-indigo-700 uppercase mb-1">New Time Suggested</p>
                                <p class="text-sm font-semibold text-slate-900">
                                    <?= date('M d', strtotime($row['suggested_start'])) ?><br>
                                    <?= date('H:i', strtotime($row['suggested_start'])) ?> - <?= date('H:i', strtotime($row['suggested_end'])) ?>
                                </p>
                                <?php if(!empty($row['rejection_reason'])): ?>
                                    <p class="text-xs text-slate-500 italic mt-1 mb-2">Note: <?= e($row['rejection_reason']) ?></p>
                                <?php endif; ?>
                                <form method="POST">
                                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                    <input type="hidden" name="action" value="accept_suggestion">
                                    <button type="submit" class="w-full mt-2 rounded bg-indigo-600 px-2 py-1.5 text-xs font-semibold text-white shadow-sm hover:bg-indigo-500">
                                        Accept New Time
                                    </button>
                                </form>
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
        <?php if($bookings->num_rows === 0): ?>
            <div class="text-center py-12">
                <p class="text-slate-500">You haven't made any bookings yet.</p>
                <a href="book.php" class="text-indigo-600 font-medium hover:underline mt-2 inline-block">Book a Lab Now</a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php tailwind_foot(); ?>