<nav class="bg-white shadow mb-8" x-data="{ open: false }">
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        <div class="flex h-16 justify-between">
            <div class="flex items-center">
                <h1 class="text-xl font-bold text-indigo-600">Tutor Portal</h1>
            </div>
            
            <div class="hidden sm:ml-6 sm:flex sm:items-center sm:space-x-4">
                <a href="dashboard.php" class="text-slate-900 px-3 py-2 text-sm font-medium hover:text-indigo-600">Dashboard</a>
                <a href="book.php" class="text-slate-500 px-3 py-2 text-sm font-medium hover:text-slate-700 hover:text-indigo-600">Book Lab</a>
                <a href="my_bookings.php" class="text-slate-500 px-3 py-2 text-sm font-medium hover:text-slate-700 hover:text-indigo-600">My History</a>
                <a href="../logout.php" class="text-red-600 px-3 py-2 text-sm font-medium hover:text-red-800">Logout</a>
                <?php $unread = get_unread_count($_SESSION['user_id']); ?>
<a href="../notifications.php" class="relative text-slate-500 px-3 py-2 text-sm font-medium hover:text-indigo-600">
    Notifications
    <?php if($unread > 0): ?>
        <span class="absolute top-0 right-0 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-red-100 transform translate-x-1/2 -translate-y-1/2 bg-red-600 rounded-full"><?= $unread ?></span>
    <?php endif; ?>
</a>
            </div>

            <div class="-mr-2 flex items-center sm:hidden">
                <button type="button" onclick="document.getElementById('mobile-menu').classList.toggle('hidden')" class="inline-flex items-center justify-center rounded-md p-2 text-slate-400 hover:bg-slate-100 hover:text-slate-500 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-indigo-500">
                    <span class="sr-only">Open main menu</span>
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </div>
        </div>
    </div>

    <div class="hidden sm:hidden bg-slate-50 border-t border-slate-200" id="mobile-menu">
        <div class="space-y-1 pb-3 pt-2">
            <a href="dashboard.php" class="block border-l-4 border-indigo-500 bg-indigo-50 py-2 pl-3 pr-4 text-base font-medium text-indigo-700">Dashboard</a>
            <a href="book.php" class="block border-l-4 border-transparent py-2 pl-3 pr-4 text-base font-medium text-slate-500 hover:border-slate-300 hover:bg-slate-50 hover:text-slate-700">Book Lab</a>
            <a href="my_bookings.php" class="block border-l-4 border-transparent py-2 pl-3 pr-4 text-base font-medium text-slate-500 hover:border-slate-300 hover:bg-slate-50 hover:text-slate-700">My History</a>
            <a href="../logout.php" class="block border-l-4 border-transparent py-2 pl-3 pr-4 text-base font-medium text-red-600 hover:bg-red-50">Logout</a>
        </div>
    </div>
</nav>