<?php
// public/signup.php
require_once '../config/db.php';
require_once '../lib/functions.php';

$error = '';
$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm = $_POST['confirm_password'];

    // Basic Validation
    if ($password !== $confirm) {
        $error = "Passwords do not match.";
    } else {
        // Check if email exists
        $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();
        
        if ($stmt->num_rows > 0) {
            $error = "Email already registered.";
        } else {
            // Create Tutor Account (Active by default, or change 1 to 0 if admin must approve)
            $hash = password_hash($password, PASSWORD_BCRYPT);
            $role = 'tutor';
            $is_active = 1; 

            $stmt = $conn->prepare("INSERT INTO users (name, email, role, password_hash, is_active) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("ssssi", $name, $email, $role, $hash, $is_active);
            
            if ($stmt->execute()) {
                $msg = "Account created! You can now login.";
            } else {
                $error = "Error: " . $conn->error;
            }
        }
    }
}

tailwind_head("Tutor Signup");
?>
<div class="flex min-h-full flex-col justify-center px-6 py-12 lg:px-8">
  <div class="sm:mx-auto sm:w-full sm:max-w-sm">
    <h2 class="mt-10 text-center text-2xl font-bold leading-9 tracking-tight text-slate-900">Create Tutor Account</h2>
  </div>

  <div class="mt-10 sm:mx-auto sm:w-full sm:max-w-sm">
    <?php if($error): ?><div class="bg-red-100 text-red-700 p-3 mb-4 rounded"><?= e($error) ?></div><?php endif; ?>
    <?php if($msg): ?>
        <div class="bg-green-100 text-green-700 p-3 mb-4 rounded">
            <?= e($msg) ?> <br> <a href="login.php" class="font-bold underline">Go to Login</a>
        </div>
    <?php endif; ?>

    <?php if(!$msg): ?>
    <form class="space-y-6" action="" method="POST">
      <div>
        <label class="block text-sm font-medium leading-6 text-slate-900">Full Name</label>
        <div class="mt-2"><input name="name" type="text" required class="block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300 focus:ring-2 focus:ring-indigo-600"></div>
      </div>
      
      <div>
        <label class="block text-sm font-medium leading-6 text-slate-900">Email address</label>
        <div class="mt-2"><input name="email" type="email" required class="block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300 focus:ring-2 focus:ring-indigo-600"></div>
      </div>

      <div>
        <label class="block text-sm font-medium leading-6 text-slate-900">Password</label>
        <div class="mt-2"><input name="password" type="password" required class="block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300 focus:ring-2 focus:ring-indigo-600"></div>
      </div>

      <div>
        <label class="block text-sm font-medium leading-6 text-slate-900">Confirm Password</label>
        <div class="mt-2"><input name="confirm_password" type="password" required class="block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300 focus:ring-2 focus:ring-indigo-600"></div>
      </div>

      <div>
        <button type="submit" class="flex w-full justify-center rounded-md bg-indigo-600 px-3 py-1.5 text-sm font-semibold leading-6 text-white shadow-sm hover:bg-indigo-500">Sign Up</button>
      </div>
    </form>
    <p class="mt-10 text-center text-sm text-slate-500">
      Already have an account? <a href="login.php" class="font-semibold leading-6 text-indigo-600 hover:text-indigo-500">Login here</a>
    </p>
    <?php endif; ?>
  </div>
</div>
<?php tailwind_foot(); ?>