<?php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('admin');

$msg = '';
$err = '';

// Handle Create/Update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $capacity = (int)$_POST['capacity'];
    $status = $_POST['status'];
    $id = $_POST['id'] ?? null;

    if ($id) {
        // Update
        $stmt = $conn->prepare("UPDATE labs SET name=?, capacity=?, status=? WHERE id=?");
        $stmt->bind_param("sisi", $name, $capacity, $status, $id);
    } else {
        // Create
        $stmt = $conn->prepare("INSERT INTO labs (name, capacity, status) VALUES (?, ?, ?)");
        $stmt->bind_param("sis", $name, $capacity, $status);
    }

    if ($stmt->execute()) {
        $msg = "Lab saved successfully.";
    } else {
        $err = "Error saving lab (Name must be unique).";
    }
}

$labs = $conn->query("SELECT * FROM labs");

tailwind_head("Manage Labs");
?>
<div>
    <?php include '_sidebar.php'; ?>
    <div class="lg:pl-72">
        <main class="py-10 px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6">Manage Labs</h1>
            
            <?php if($msg): ?><div class="bg-green-100 text-green-700 p-3 mb-4 rounded"><?= e($msg) ?></div><?php endif; ?>
            <?php if($err): ?><div class="bg-red-100 text-red-700 p-3 mb-4 rounded"><?= e($err) ?></div><?php endif; ?>

            <div class="bg-white p-6 rounded-lg shadow mb-8">
                <h2 class="text-lg font-medium mb-4">Add / Edit Lab</h2>
                <form method="POST" class="flex gap-4 items-end flex-wrap">
                    <input type="hidden" name="id" id="lab_id">
                    <div>
                        <label class="block text-sm font-medium text-slate-700">Lab Name</label>
                        <input type="text" name="name" id="lab_name" required class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700">Capacity</label>
                        <input type="number" name="capacity" id="lab_cap" required class="mt-1 block w-24 rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700">Status</label>
                        <select name="status" id="lab_status" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2">
                            <option value="available">Available</option>
                            <option value="maintenance">Maintenance</option>
                        </select>
                    </div>
                    <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">Save Lab</button>
                    <button type="button" onclick="resetForm()" class="bg-slate-200 text-slate-700 px-4 py-2 rounded-md hover:bg-slate-300">Clear</button>
                </form>
            </div>

            <div class="overflow-hidden shadow ring-1 ring-black ring-opacity-5 sm:rounded-lg">
                <table class="min-w-full divide-y divide-slate-300">
                    <thead class="bg-slate-50">
                        <tr>
                            <th class="py-3.5 pl-4 text-left text-sm font-semibold text-slate-900">Name</th>
                            <th class="px-3 py-3.5 text-left text-sm font-semibold text-slate-900">Capacity</th>
                            <th class="px-3 py-3.5 text-left text-sm font-semibold text-slate-900">Status</th>
                            <th class="px-3 py-3.5 text-right text-sm font-semibold text-slate-900">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200 bg-white">
                        <?php while($row = $labs->fetch_assoc()): ?>
                        <tr>
                            <td class="whitespace-nowrap py-4 pl-4 text-sm font-medium text-slate-900"><?= e($row['name']) ?></td>
                            <td class="whitespace-nowrap px-3 py-4 text-sm text-slate-500"><?= e($row['capacity']) ?></td>
                            <td class="whitespace-nowrap px-3 py-4 text-sm">
                                <span class="inline-flex items-center rounded-md px-2 py-1 text-xs font-medium ring-1 ring-inset ring-gray-500/10 <?= $row['status']=='available'?'bg-green-50 text-green-700':'bg-red-50 text-red-700' ?>">
                                    <?= ucfirst($row['status']) ?>
                                </span>
                            </td>
                            <td class="whitespace-nowrap px-3 py-4 text-right text-sm font-medium">
                                <button onclick='editLab(<?= json_encode($row) ?>)' class="text-indigo-600 hover:text-indigo-900">Edit</button>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</div>

<script>
function editLab(data) {
    document.getElementById('lab_id').value = data.id;
    document.getElementById('lab_name').value = data.name;
    document.getElementById('lab_cap').value = data.capacity;
    document.getElementById('lab_status').value = data.status;
}
function resetForm() {
    document.getElementById('lab_id').value = '';
    document.getElementById('lab_name').value = '';
    document.getElementById('lab_cap').value = '';
}
</script>
<?php tailwind_foot(); ?>