<?php
// public/admin/dashboard.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('admin');

// Quick Stats
$stats = [
    'pending' => $conn->query("SELECT COUNT(*) FROM bookings WHERE status='pending'")->fetch_row()[0],
    'approved' => $conn->query("SELECT COUNT(*) FROM bookings WHERE status='approved'")->fetch_row()[0],
    'labs' => $conn->query("SELECT COUNT(*) FROM labs")->fetch_row()[0],
    'courses' => $conn->query("SELECT COUNT(*) FROM courses WHERE is_active=1")->fetch_row()[0],
];

tailwind_head("Admin Dashboard");
?>
<div>
    <?php include '_sidebar.php'; ?>
    <div class="lg:pl-72">
        <main class="py-10">
            <div class="px-4 sm:px-6 lg:px-8">
                <h1 class="text-2xl font-bold leading-7 text-slate-900 sm:truncate sm:tracking-tight mb-8">Dashboard</h1>
                
                <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-4">
                    <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
                        <dt class="truncate text-sm font-medium text-slate-500">Pending Bookings</dt>
                        <dd class="mt-1 text-3xl font-semibold tracking-tight text-indigo-600"><?= $stats['pending'] ?></dd>
                    </div>
                    
                    <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
                        <dt class="truncate text-sm font-medium text-slate-500">Approved Bookings</dt>
                        <dd class="mt-1 text-3xl font-semibold tracking-tight text-green-600"><?= $stats['approved'] ?></dd>
                    </div>

                    <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
                        <dt class="truncate text-sm font-medium text-slate-500">Total Labs</dt>
                        <dd class="mt-1 text-3xl font-semibold tracking-tight text-slate-900"><?= $stats['labs'] ?></dd>
                    </div>
                    
                    <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
                        <dt class="truncate text-sm font-medium text-slate-500">Active Courses</dt>
                        <dd class="mt-1 text-3xl font-semibold tracking-tight text-slate-900"><?= $stats['courses'] ?></dd>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>
<?php tailwind_foot(); ?>