<?php
// public/admin/bulk_users.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('admin');

$msg = '';
$counts = ['success' => 0, 'error' => 0];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    $file = $_FILES['csv_file']['tmp_name'];
    
    if (($handle = fopen($file, "r")) !== FALSE) {
        // Default password hash for "password"
        $default_hash = password_hash("password", PASSWORD_BCRYPT);
        
        $stmt = $conn->prepare("INSERT IGNORE INTO users (name, email, role, password_hash, is_active) VALUES (?, ?, ?, ?, 1)");
        
        // Skip header row if needed (optional)
        // fgetcsv($handle); 

        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            // Expected CSV: Name, Email, Role
            if (count($data) >= 3) {
                $name = trim($data[0]);
                $email = trim($data[1]);
                $role = strtolower(trim($data[2]));
                
                if (!in_array($role, ['admin', 'tutor'])) $role = 'tutor';

                $stmt->bind_param("ssss", $name, $email, $role, $default_hash);
                if ($stmt->execute() && $stmt->affected_rows > 0) {
                    $counts['success']++;
                } else {
                    $counts['error']++;
                }
            }
        }
        fclose($handle);
        $msg = "Import Complete: {$counts['success']} created, {$counts['error']} skipped/duplicates.";
    }
}

tailwind_head("Bulk Upload Users");
?>
<div>
    <?php include '_sidebar.php'; ?>
    <div class="lg:pl-72">
        <main class="py-10 px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6">Bulk Upload Users</h1>
            
            <?php if($msg): ?>
                <div class="bg-blue-50 border-l-4 border-blue-400 p-4 mb-6">
                    <div class="flex">
                        <div class="ml-3">
                            <p class="text-sm text-blue-700"><?= e($msg) ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="bg-white p-6 rounded shadow max-w-xl">
                <h3 class="text-lg font-medium leading-6 text-gray-900 mb-4">Upload CSV</h3>
                <p class="text-sm text-gray-500 mb-4">
                    Format: <code>Name, Email, Role</code> (no header required).<br>
                    Default password will be set to: <strong>password</strong>
                </p>
                
                <form method="POST" enctype="multipart/form-data" class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">CSV File</label>
                        <input type="file" name="csv_file" accept=".csv" required class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                    </div>
                    <button type="submit" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700">Upload Users</button>
                </form>
            </div>
        </main>
    </div>
</div>
<?php tailwind_foot(); ?>