<?php
// public/admin/bulk_courses.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('admin');

// Helper to get department ID by name (or create it)
function get_dept_id($conn, $name) {
    if (empty($name)) return null;
    
    // Check exist
    $stmt = $conn->prepare("SELECT id FROM departments WHERE name = ?");
    $stmt->bind_param("s", $name);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($row = $res->fetch_assoc()) return $row['id'];
    
    // Create new
    $stmt = $conn->prepare("INSERT INTO departments (name) VALUES (?)");
    $stmt->bind_param("s", $name);
    $stmt->execute();
    return $stmt->insert_id;
}

$msg = '';
$counts = ['success' => 0, 'error' => 0];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    $file = $_FILES['csv_file']['tmp_name'];
    
    if (($handle = fopen($file, "r")) !== FALSE) {
        $stmt = $conn->prepare("INSERT IGNORE INTO courses (code, name, department_id, is_active) VALUES (?, ?, ?, 1)");
        
        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            // Expected: Code, Name, Department
            if (count($data) >= 2) {
                $code = trim($data[0]);
                $name = trim($data[1]);
                $dept_name = isset($data[2]) ? trim($data[2]) : '';
                
                $dept_id = get_dept_id($conn, $dept_name);
                
                $stmt->bind_param("ssi", $code, $name, $dept_id);
                if ($stmt->execute() && $stmt->affected_rows > 0) {
                    $counts['success']++;
                } else {
                    $counts['error']++;
                }
            }
        }
        fclose($handle);
        $msg = "Import Complete: {$counts['success']} added, {$counts['error']} skipped/duplicates.";
    }
}

tailwind_head("Bulk Upload Courses");
?>
<div>
    <?php include '_sidebar.php'; ?>
    <div class="lg:pl-72">
        <main class="py-10 px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6">Bulk Upload Courses</h1>
            <?php if($msg): ?><div class="bg-blue-100 text-blue-700 p-3 mb-4 rounded"><?= e($msg) ?></div><?php endif; ?>

            <div class="bg-white p-6 rounded shadow max-w-xl">
                <h3 class="text-lg font-medium mb-4">Upload CSV</h3>
                <p class="text-sm text-gray-500 mb-4">Format: <code>Code, Name, Department</code></p>
                <form method="POST" enctype="multipart/form-data" class="space-y-4">
                    <input type="file" name="csv_file" accept=".csv" required class="block w-full text-sm text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:bg-indigo-50 file:text-indigo-700">
                    <button type="submit" class="w-full bg-indigo-600 text-white py-2 px-4 rounded shadow hover:bg-indigo-700">Upload Courses</button>
                </form>
            </div>
        </main>
    </div>
</div>
<?php tailwind_foot(); ?>