<?php
// public/admin/bookings.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('admin');

$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)$_POST['id'];
    $admin_id = $_SESSION['user_id'];
    
    // FETCH BOOKING DETAILS for notifications
    $b_info = $conn->query("SELECT tutor_id FROM bookings WHERE id=$id")->fetch_assoc();
    $tutor_id = $b_info['tutor_id'] ?? 0;

    // --- 1. APPROVE ---
    if ($_POST['action'] === 'approve') {
        $b = $conn->query("SELECT * FROM bookings WHERE id = $id")->fetch_assoc();
        
        // Double check overlap
        if (overlap_exists($b['lab_id'], $b['start_time'], $b['end_time'], $id)) {
            $msg = "Error: Conflict detected with another approved booking.";
        } else {
            $conn->query("UPDATE bookings SET status='approved', approval_by=$admin_id WHERE id=$id");
            if($tutor_id) notify($tutor_id, "Your booking has been approved.", "tutor/my_bookings.php");
            $msg = "Booking Approved.";
        }
    } 
    // --- 2. REJECT ---
    elseif ($_POST['action'] === 'reject') {
        $reason = trim($_POST['rejection_reason']);
        if(empty($reason)) $reason = "No reason provided.";

        $stmt = $conn->prepare("UPDATE bookings SET status='rejected', approval_by=?, rejection_reason=? WHERE id=?");
        $stmt->bind_param("isi", $admin_id, $reason, $id);
        $stmt->execute();
        
        if($tutor_id) notify($tutor_id, "Your booking was rejected: $reason", "tutor/my_bookings.php");
        $msg = "Booking Rejected.";
    }
    // --- 3. SUGGEST TIME ---
    elseif ($_POST['action'] === 'suggest') {
        $s_start = str_replace('T', ' ', $_POST['suggested_start']) . ':00';
        $s_end = str_replace('T', ' ', $_POST['suggested_end']) . ':00';
        $note = trim($_POST['suggestion_note']);
        
        $stmt = $conn->prepare("UPDATE bookings SET status='change_requested', approval_by=?, suggested_start=?, suggested_end=?, rejection_reason=? WHERE id=?");
        $stmt->bind_param("issss", $admin_id, $s_start, $s_end, $note, $id);
        $stmt->execute();
        
        if($tutor_id) notify($tutor_id, "Admin suggested a new time for your booking.", "tutor/my_bookings.php");
        $msg = "Suggestion sent to tutor.";
    }
}

// Fetch All Bookings
$bookings = $conn->query("SELECT b.*, u.name as tutor, l.name as lab, c.name as course_name 
                          FROM bookings b 
                          JOIN users u ON b.tutor_id = u.id 
                          JOIN labs l ON b.lab_id = l.id 
                          LEFT JOIN courses c ON b.course_id = c.id 
                          ORDER BY b.created_at DESC");

tailwind_head("Manage Bookings");
?>
<div>
    <?php include '_sidebar.php'; ?>
    <div class="lg:pl-72">
        <main class="py-10 px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6">Booking Management</h1>
            <?php if($msg): ?><div class="bg-blue-100 text-blue-700 p-3 mb-4 rounded"><?= e($msg) ?></div><?php endif; ?>

            <input type="text" id="liveSearch" onkeyup="tableSearch()" placeholder="Search bookings..." class="border p-2 rounded w-full mb-4 shadow-sm focus:ring-2 focus:ring-indigo-500">
            
            <div class="overflow-x-auto shadow ring-1 ring-black ring-opacity-5 sm:rounded-lg">
                <table class="min-w-full divide-y divide-slate-300">
                    <thead class="bg-slate-50">
                        <tr>
                            <th class="py-3.5 pl-4 text-left text-sm font-semibold text-slate-900">Details</th>
                            <th class="px-3 py-3.5 text-left text-sm font-semibold text-slate-900">Time</th>
                            <th class="px-3 py-3.5 text-left text-sm font-semibold text-slate-900">Status</th>
                            <th class="px-3 py-3.5 text-right text-sm font-semibold text-slate-900">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200 bg-white">
                        <?php while($row = $bookings->fetch_assoc()): ?>
                        <tr>
                            <td class="py-4 pl-4 text-sm align-top">
                                <div class="font-bold text-slate-900"><?= e($row['tutor']) ?></div>
                                <div class="text-slate-500"><?= e($row['course_name']) ?></div>
                                <div class="text-xs text-slate-400"><?= e($row['lab']) ?> | Purpose: <?= e($row['purpose']) ?></div>
                                <?php if($row['notes']): ?>
                                    <div class="text-xs text-indigo-600 mt-1">Note: <?= e($row['notes']) ?></div>
                                <?php endif; ?>
                            </td>

                            <td class="px-3 py-4 text-sm text-slate-500 align-top">
                                <div class="<?= $row['suggested_start'] ? 'line-through text-red-300' : '' ?>">
                                    <?= date('M d, H:i', strtotime($row['start_time'])) ?> - <?= date('H:i', strtotime($row['end_time'])) ?>
                                </div>
                                <?php if($row['suggested_start']): ?>
                                    <div class="text-indigo-600 font-bold mt-1 text-xs">
                                        Suggested:<br>
                                        <?= date('M d, H:i', strtotime($row['suggested_start'])) ?> - <?= date('H:i', strtotime($row['suggested_end'])) ?>
                                    </div>
                                <?php endif; ?>
                            </td>

                            <td class="px-3 py-4 text-sm align-top">
                                <span class="px-2 py-1 rounded-full text-xs font-medium 
                                    <?= $row['status'] == 'approved' ? 'bg-green-100 text-green-800' : 
                                       ($row['status'] == 'change_requested' ? 'bg-indigo-100 text-indigo-800' : 
                                       ($row['status'] == 'rejected' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800')) ?>">
                                    <?= ucfirst(str_replace('_', ' ', $row['status'])) ?>
                                </span>
                                <?php if($row['status'] == 'rejected' && $row['rejection_reason']): ?>
                                    <div class="text-xs text-red-600 mt-1 max-w-[150px] border-l-2 border-red-200 pl-1"><?= e($row['rejection_reason']) ?></div>
                                <?php endif; ?>
                            </td>

                            <td class="px-3 py-4 text-right text-sm align-top">
                                <?php if($row['status'] === 'pending'): ?>
                                    <div class="flex flex-col gap-2 items-end">
                                        <form method="POST">
                                            <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                            <button name="action" value="approve" class="text-green-600 hover:text-green-900 font-bold text-xs bg-green-50 px-2 py-1 rounded border border-green-200">Approve</button>
                                        </form>
                                        
                                        <button onclick="openSuggestModal(<?= $row['id'] ?>)" class="text-indigo-600 hover:text-indigo-900 font-bold text-xs bg-indigo-50 px-2 py-1 rounded border border-indigo-200">Suggest Time</button>
                                        
                                        <button onclick="openRejectModal(<?= $row['id'] ?>)" class="text-red-600 hover:text-red-900 font-bold text-xs bg-red-50 px-2 py-1 rounded border border-red-200">Reject</button>
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</div>

<div id="suggestModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-75 flex items-center justify-center z-50">
    <div class="bg-white rounded-lg p-6 max-w-sm w-full shadow-xl">
        <h3 class="text-lg font-bold mb-4 text-indigo-600">Suggest Alternative Time</h3>
        <form method="POST">
            <input type="hidden" name="action" value="suggest">
            <input type="hidden" name="id" id="suggest_id">
            
            <label class="block text-sm font-medium mb-1">New Start Time</label>
            <input type="datetime-local" name="suggested_start" required class="w-full border p-2 rounded mb-3">
            
            <label class="block text-sm font-medium mb-1">New End Time</label>
            <input type="datetime-local" name="suggested_end" required class="w-full border p-2 rounded mb-3">
            
            <label class="block text-sm font-medium mb-1">Note (Optional)</label>
            <textarea name="suggestion_note" class="w-full border p-2 rounded mb-4" placeholder="e.g. Lab 1 is full, please try..."></textarea>
            
            <div class="flex justify-end gap-2">
                <button type="button" onclick="document.getElementById('suggestModal').classList.add('hidden')" class="bg-gray-200 px-4 py-2 rounded">Cancel</button>
                <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded">Send Suggestion</button>
            </div>
        </form>
    </div>
</div>

<div id="rejectModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-75 flex items-center justify-center z-50">
    <div class="bg-white rounded-lg p-6 max-w-sm w-full shadow-xl">
        <h3 class="text-lg font-bold mb-4 text-red-600">Reject Booking</h3>
        <form method="POST">
            <input type="hidden" name="action" value="reject">
            <input type="hidden" name="id" id="reject_id">
            
            <label class="block text-sm font-medium mb-2">Reason for Rejection</label>
            <textarea name="rejection_reason" rows="3" required class="w-full border p-2 rounded mb-4 focus:ring-red-500" placeholder="e.g. Lab maintenance, Time conflict..."></textarea>
            
            <div class="flex justify-end gap-2">
                <button type="button" onclick="document.getElementById('rejectModal').classList.add('hidden')" class="bg-gray-200 px-4 py-2 rounded">Cancel</button>
                <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700">Confirm Reject</button>
            </div>
        </form>
    </div>
</div>

<script>
function openSuggestModal(id) {
    document.getElementById('suggest_id').value = id;
    document.getElementById('suggestModal').classList.remove('hidden');
}

function openRejectModal(id) {
    document.getElementById('reject_id').value = id;
    document.getElementById('rejectModal').classList.remove('hidden');
}
</script>
<?php tailwind_foot(); ?>