<div class="sticky top-0 z-40 flex items-center gap-x-6 bg-slate-900 px-4 py-4 shadow-sm sm:px-6 lg:hidden">
    <button type="button" class="-m-2.5 p-2.5 text-slate-400 hover:text-white" onclick="toggleSidebar()">
        <span class="sr-only">Open sidebar</span>
        <i class="fas fa-bars text-xl"></i>
    </button>
    <div class="flex-1 text-sm font-semibold leading-6 text-white">LabManager Admin</div>
    <a href="../logout.php" class="text-sm font-semibold leading-6 text-red-400">Logout</a>
</div>

<div id="adminSidebar" class="hidden lg:fixed lg:inset-y-0 lg:z-50 lg:flex lg:w-72 lg:flex-col">
    <div class="flex grow flex-col gap-y-5 overflow-y-auto bg-slate-900 px-6 pb-4">
        
        <div class="flex h-16 shrink-0 items-center">
            <span class="text-white text-xl font-bold tracking-wider">
                <i class="fas fa-network-wired mr-2 text-indigo-500"></i>LabManager
            </span>
            <button class="ml-auto lg:hidden text-slate-400 hover:text-white" onclick="toggleSidebar()">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>

        <nav class="flex flex-1 flex-col">
            <ul role="list" class="flex flex-1 flex-col gap-y-7">
                <li>
                    <ul role="list" class="-mx-2 space-y-1">
                        <li><a href="dashboard.php" class="text-slate-300 hover:bg-slate-800 hover:text-white group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"><i class="fas fa-home w-6 text-center shrink-0 mt-1"></i> Dashboard</a></li>
                        <li><a href="bookings.php" class="text-slate-300 hover:bg-slate-800 hover:text-white group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"><i class="fas fa-calendar-check w-6 text-center shrink-0 mt-1"></i> Bookings</a></li>
                        <li><a href="labs.php" class="text-slate-300 hover:bg-slate-800 hover:text-white group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"><i class="fas fa-desktop w-6 text-center shrink-0 mt-1"></i> Labs</a></li>
                        <li><a href="classes.php" class="text-slate-300 hover:bg-slate-800 hover:text-white group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"><i class="fas fa-layer-group w-6 text-center shrink-0 mt-1"></i> Classes</a></li>
                        <li><a href="courses.php" class="text-slate-300 hover:bg-slate-800 hover:text-white group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"><i class="fas fa-book w-6 text-center shrink-0 mt-1"></i> Courses</a></li>
                        <li><a href="users.php" class="text-slate-300 hover:bg-slate-800 hover:text-white group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"><i class="fas fa-users w-6 text-center shrink-0 mt-1"></i> Users</a></li>
                        
                        <li class="mt-4">
                            <div class="text-xs font-semibold leading-6 text-slate-500 uppercase tracking-wider">Tools</div>
                            <ul role="list" class="-mx-2 mt-2 space-y-1">
                                <li><a href="bulk_users.php" class="text-slate-300 hover:bg-slate-800 hover:text-white group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"><i class="fas fa-file-csv w-6 text-center shrink-0 mt-1"></i> Upload Users</a></li>
                                <li><a href="bulk_courses.php" class="text-slate-300 hover:bg-slate-800 hover:text-white group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"><i class="fas fa-file-import w-6 text-center shrink-0 mt-1"></i> Upload Courses</a></li>
                            </ul>
                        </li>
                    </ul>
                </li>
                <li class="mt-auto">
                    <ul role="list" class="-mx-2 space-y-1">
                        <li><a href="settings.php" class="text-slate-300 hover:bg-slate-800 hover:text-red-400 group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"><i class="fas fa-cogs w-6 text-center shrink-0 mt-1"></i> Settings</a></li>
                        <li><a href="../logout.php" class="text-red-400 hover:bg-slate-800 hover:text-red-300 group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"><i class="fas fa-sign-out-alt w-6 text-center shrink-0 mt-1"></i> Logout</a></li>
                    </ul>
                    <li>
    <?php $unread = get_unread_count($_SESSION['user_id']); ?>
    <a href="../notifications.php" class="text-slate-300 hover:bg-slate-800 hover:text-white group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold">
        <div class="relative">
            <i class="fas fa-bell w-6 text-center shrink-0 mt-1"></i>
            <?php if($unread > 0): ?>
                <span class="absolute -top-2 -right-2 bg-red-500 text-white text-xs rounded-full h-4 w-4 flex items-center justify-center"><?= $unread ?></span>
            <?php endif; ?>
        </div>
        Notifications
    </a>
</li>

<li>
    <a href="schedule.php" class="text-slate-300 hover:bg-slate-800 hover:text-white group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold">
        <i class="fas fa-clock w-6 text-center shrink-0 mt-1"></i> Schedule View
    </a>
</li>
                </li>
            </ul>
        </nav>
    </div>
</div>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('adminSidebar');
    // On mobile, we want to make it fixed full screen when open
    if (sidebar.classList.contains('hidden')) {
        sidebar.classList.remove('hidden');
        sidebar.classList.add('fixed', 'inset-0', 'z-50', 'w-full');
    } else {
        sidebar.classList.add('hidden');
        sidebar.classList.remove('fixed', 'inset-0', 'z-50', 'w-full');
    }
}

function tableSearch() {
    var input = document.getElementById("liveSearch");
    if (!input) return;
    var filter = input.value.toUpperCase();
    var rows = document.querySelectorAll("tbody tr");
    rows.forEach(row => {
        var text = row.textContent || row.innerText;
        row.style.display = text.toUpperCase().indexOf(filter) > -1 ? "" : "none";
    });
}
</script>